<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Comment\Like;

trait TraitPostCommentLikeGetters
{
    use TraitPostCommentLikeProperties;

    final public function getId(): string
    {
        return $this -> id;
    }

    public function getOwnerUserId(): string
    {
        return $this -> likedByUserId;
    }

    public function getParentPostCommentId(): string
    {
        return $this -> likedPostCommentId;
    }

    public function getParentPostId(): string
    {
        return $this -> parentPostId;
    }

    public function getStampRegistration(): string
    {
        return $this -> stampRegistration;
    }

    public function getStampLastUpdate(): string
    {
        return $this -> stampLastUpdate;
    }
}
